/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.event.SystemAnalysisCompleteEvent;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.domain.AnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;

public class SystemAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPASYART";
    private static final String TRACE_MASKF = "XPASYARF";
    private static final String TRACE_MASKD = "XPASYARD";
    private static final boolean UNIT_TEST = true;

    public SystemAnalysisRoutine() {
        Trace.trace(TRACE_MASKF, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        CommonServiceAREvent ourEvent = (CommonServiceAREvent)event;
        PASystem system = ourEvent.getSystem();
        String poolId = ourEvent.getIncidentPoolId();
        DomainIdentifier domainId = CommonDataEvent.extractDomainId(poolId);
        Trace.trace(TRACE_MASKD, "event domain: " + domainId.getDID());
        AnalysisDomain ad = (AnalysisDomain)((Object)DomainManager.getDomainManager().get(domainId));
        if (ad == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): cannot obtain domain for event");
            return;
        }
        Trace.trace(TRACE_MASKD, "post an System/AnalysisDomainAnalysisEvent");
        this.postServiceAREvent(ad.getSystemAnalysisEvent(this), system, poolId);
        Trace.trace(TRACE_MASKD, "post a SystemAnalysisCompleteEvent");
        this.postServiceAREvent(new SystemAnalysisCompleteEvent(this), system, poolId);
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }
}

